//-----------------------------------------------------------------------------
// Microsoft OLE DB RowsetViewer					   
// Copyright (C) 1994 - 1998 By Microsoft Corporation.
//
// @doc
//
// @module CENUM.H
//
//-----------------------------------------------------------------------------------

#ifndef _CENUM_H_
#define _CENUM_H_


///////////////////////////////////////////////////////////////
// Includes
//
///////////////////////////////////////////////////////////////
#include "Common.h"


///////////////////////////////////////////////////////////////
// Forwards
//
///////////////////////////////////////////////////////////////
class CMainWindow;
class CListBox;


///////////////////////////////////////////////////////////////
// Defines
//
///////////////////////////////////////////////////////////////
//ENUMINFO
struct ENUMINFO
{
	WCHAR			wszName[MAX_NAME_LEN];
	WCHAR			wszParseName[MAX_NAME_LEN];
	WCHAR			wszDescription[MAX_NAME_LEN];
	DBTYPE			wType;
	VARIANT_BOOL	fIsParent;
};


/////////////////////////////////////////////////////////////////
// CEnum class
//
/////////////////////////////////////////////////////////////////
class CEnum
{
public:
	//Constructors
	CEnum(HWND hWnd, CMainWindow* pCMainWindow, CListBox* pCListBox);
	virtual ~CEnum();

	//Connection
	virtual HRESULT		CreateProvider(IParseDisplayName* pIParseDisplayName, WCHAR* pwszParseName, DWORD dwCLSCTX, REFIID riid, IUnknown** ppIUnknown, DWORD dwConnectOpts, WCHAR* pwszRemoteServer = NULL);
	virtual HRESULT		CreateProvider(IUnknown* pIUnkOuter, CLSID clsid, DWORD dwCLSCTX, REFIID riid, IUnknown** ppIUnknown, DWORD dwConnectOpts, WCHAR* pwszRemoteServer = NULL);
	virtual HRESULT		CreateInstance(IUnknown* pIUnkOuter, CLSID clsid, DWORD dwCLSCTX, REFIID riid, IUnknown** ppIUnknown, WCHAR* pwszRemoteServer = NULL);

	//EnumInfo
	virtual ENUMINFO*	GetEnumInfo();
	virtual ENUMINFO*	GetEnumInfo(ULONG iIndex);

	virtual BOOL		IsConnectedToRootEnum();
	virtual HRESULT		ConnectToRootEnum();
	virtual HRESULT 	GetEnumRowset(IParseDisplayName* pIParseDisplayName, ULONG* pcEnumInfo, ENUMINFO** prgEnumInfo);

	//Objects
	CMainWindow*		m_pCMainWindow;
	CListBox*			m_pCListBox;

	//Root Enumerator
	IParseDisplayName*	m_pIParseDisplayName;	//Enum interface

	//Enumerator ProvierInfo
	ULONG				m_cEnumInfo;	
	ENUMINFO*			m_rgEnumInfo;
	HWND				m_hWnd;
};


#endif	//_CENUM_H_
